 ; -----------------------------------------
; NTG8025 Steuer-CPU steuert nur den Thyristor, der U-I-Regler ist Analog.
; 250VA Labornetzgert mit Thyristor auf der Sekundrseite des Netztrafos 
; -----------------------------------------

.nolist
	.include "tn25def.inc"
	.include "allgdef.inc"
.list

.CSEG

.org 0x0000 ;Set address of next statement
	rjmp restart ; Address 0x0000
	rjmp test5 ;INT0_ISR ; Address 0x0001
	rjmp test5 ;PCINT0_ISR ; Address 0x0002
	rjmp test5 ;TIM1_COMPA_ISR ; Address 0x0003
	rjmp test5 ;TIM1_OVF_ISR ; Address 0x0004
	rjmp test5 ;TIM0_OVF_ISR ; Address 0x0005
	rjmp test5 ;EE_RDY_ISR ; Address 0x0006
	rjmp test5 ;ANA_COMP_ISR ; Address 0x0007
	rjmp test5 ;ADC_ISR ; Address 0x0008
	rjmp test5  ;TIM1_COMPB_ISR ; Address 0x0009
	rjmp test5 ;TIM0_COMPA_ISR ; Address 0x000A
	rjmp test5 ;TIM0_COMPB_ISR ; Address 0x000B
	rjmp test5 ;WDT_ISR ; Address 0x000C
	rjmp test5 ;USI_START_ISR ; Address 0x000D
	rjmp test5 ;USI_OVF_ISR ; Address 0x000E
	
	
restart:

; Stack
	ldi	acc0,low(RAMEND) - 2
	out	spl,acc0
	ldi	acc0,high(RAMEND) - 2
	out	sph,acc0

;	rjmp	test
		
; Ports einstellen

	ldi	acc2,0b00000001		; b0 = Ausgang Trigger
	ldi	acc0,0b00000000		; b1 = Null, b2 = Uist, b3 = Trimmer, b4 = Ladeelko
							; b5 = Debug
	out	PORTB,acc0
	out	DDRB,acc2
	; Insert nop for synchronization
	nop
	
; Wartezeit

        ldi     acc0,255
warten:
        ldi     acc2,255
warten2:
        nop
        nop
        nop
        nop
        dec     acc2
 	    brne    warten2
        dec     acc0
        brne    warten     
	
; Analog-eingnge

	ldi	acc0,0b00100011	; AVCC=Ref, links, ADC3 = Trimmer
	out	admux,acc0
	ldi	acc0,0b00000101
	out	adcsra,acc0
	
; Timer 1, die Fuse Clk/8 mu aktiviert sein!

        ldi     acc0,0b00000110	; Takt = 1us x 32 = 32us
        out     tccr1,acc0
        ldi     acc0,0
        out     tifr,acc0		; Int aus
	
; Wachhund

	ldi	acc0,0b00001111	; = 1,9s
;	out	wdtcr,acc0
	nop
	nop
;	wdr

	
;--------------------------------------------------
; HP  *********************************************
;--------------------------------------------------

; Nulldurhgang Anfang?

   hp: 

	in		acc0 ,pinb
	andi	acc0,0b00000010
	breq	hp
hp2:
	in		acc0,pinb
	andi	acc0,0b00000010
	brne	hp2

; Trigger aus, Timer Reset 0,4ms nach Nulldurchgang

	cbi    portb,impuls
	ldi		acc0,0
	out		tcnt1,acc0

; Spannung am Ladeelko, am Ausgang und Trimmer messen

	rcall	MesseLadeElko		;
	rcall	MesseAusgang		;
	rcall	MesseTrimmer
	
; Warten auf 4,16ms (+ 0,4ms)
 
phase1:
	ldi		acc2,halbewelle
	in		acc0,tcnt1
	cp		acc0,acc2		; zeit abgelaufen?
	brcs	phase1			; nein, warten
	ldi		acc0,0
	out		tcnt1,acc0		; Tiemer von Vorn
	
; Triac triggern

	rcall	holephasenzeit	; -> phasenzeit
phase2:
	in		acc0,tcnt1
	cp		acc0,phasenzeit			; soll triggern?
	brcs	phase2			; nein, warten
; Ende
	sbi    	portb,impuls
	rjmp	hp

Test5:
	nop
	nop
	
; ------------  UPs ----------------
MesseLadeElko:
	ldi	acc0,0b00100010	; AVCC=Ref, links, ADC2 = LadeElko
	out	admux,acc0
	ldi	acc2,20
mle1:	
	nop
	nop
	dec	acc2
	brne	mle1
	ldi	acc0,0b11000101	; startet Single Conversation
	out	ADCSRA,acc0
mle2:
	in	acc0,ADCSRA
	andi	acc0,0b01000000
	brne	mle2
	in		elkospannung,adch
	ret
; --------------	
MesseAusgang:
	ldi	acc0,0b00100001	; AVCC=Ref, links, ADC1 = Ausgang
	out	admux,acc0
	ldi	acc2,20
mausg1:	
	nop
	nop
	dec	acc2
	brne	mausg1
	ldi	acc0,0b11000101	; startet Single Conversation
	out	ADCSRA,acc0
mausg2:
	in	acc0,ADCSRA
	andi	acc0,0b01000000
	brne	mausg2
; Messwert von 98mV/digit auf 129mV/digit umrechnen
	in		r26,adch
	ldi		r27,193
	rcall	Mulx8		; r26 x r27 = r1:r0
	mov		ausgangsspannung,r1
	ret
; ----------------	
MesseTrimmer:
	ldi	acc0,0b00100011	; AVCC=Ref, links, ADC3 = Trimmer
	out	admux,acc0
	ldi	acc2,20
mtrim1:	
	nop
	nop
	dec	acc2
	brne	mtrim1
	ldi	acc0,0b11000101	; startet Single Conversation
	out	ADCSRA,acc0
mtrim2:
	in	acc0,ADCSRA
	andi	acc0,0b01000000
	brne	mtrim2
	in		acc0,adch
	lsr		acc0			; durch 2
	lsr		acc0			; durch 4
	mov		Trimmerspannung,acc0
	ret
; ---------------	
holephasenzeit:
; acc0 = Elko-Soll
	mov		acc0,ausgangsspannung
	add		acc0,trimmerspannung
	brcc	holephz1
	ldi		acc0,255
holephz1:
; Abeichung auf Minimum ... Maximum begrenzt	
	mov		acc2,elkospannung
	sub		acc2,acc0
	brcs	holephz2			; negativ!			
	cpi		acc2,10
	brcs	holephz4
	ldi		acc2,10
	rjmp	holephz4
; negative Abweichung begrenzen
holephz2:
	com		acc2
	cpi		acc2,10
	brcs	holephz3
	ldi		acc2,10
; negativ: subtrahieren
holephz3:
	sub		phasenzeit,acc2
	brcc	holephz3a
	ldi		phasenzeit,minimum
	rjmp	holephz3b
holephz3a:
	cpi		phasenzeit,minimum
	brcc	holephz3b
	ldi		phasenzeit,minimum
holephz3b:
	ret
; Phasenzeit aufaddieren
holephz4:
	add		acc2,phasenzeit 
	cpi		acc2,minimum
	brcc	holephz5
	ldi		acc2,minimum
	rjmp	holephz6
holephz5:
	cpi		acc2,maximum
	brcs	holephz6
	ldi		acc2,maximum
holephz6:
	mov		phasenzeit,acc2
	ret

	
; =============== Macro =====================
.MACRO	Mmulx8
	push	r2
	push	r16
	ldi		r16,8
	mov		r2,r16
	pop		r16
	clr		r1
	mov		r0,@1
	lsr		r0
Mmulx8a:
	brcc	Mmulx8b
	add		r1,@0
Mmulx8b:
	ror		r1
	ror		r0
	dec		r2
	brne	Mmulx8a
	clc
	sbrc	r1,7
	sec
	mov		r2,r1
	or		r2,r0
	pop		r2
.ENDM

Mulx8:
	Mmulx8	r26,r27		; r26 x r27 = r1:r0
	ret
	
	
Test:
	nop
	ldi		phasenzeit,50		
	ldi		ausgangsspannung,10		
	ldi		Trimmerspannung,100		
	ldi		elkospannung,110
Test2:	
	rcall	holephasenzeit
	
	rjmp	Test2		
		
			



